import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:skeletonizer/skeletonizer.dart';
import 'package:viserpay/core/utils/dimensions.dart';
import 'package:viserpay/core/utils/my_color.dart';
import 'package:viserpay/core/utils/my_strings.dart';
import 'package:viserpay/core/utils/style.dart';
import 'package:viserpay/core/utils/util.dart';
import 'package:viserpay/data/controller/nominee/nominee_controller.dart';
import 'package:viserpay/data/model/kyc/kyc_response_model.dart';
import 'package:viserpay/data/repo/nominee/nominee_repo.dart';
import 'package:viserpay/data/services/api_service.dart';
import 'package:viserpay/view/components/app-bar/custom_appbar.dart';
import 'package:viserpay/view/components/buttons/gradient_rounded_button.dart';
import 'package:viserpay/view/components/form_row.dart';
import 'package:viserpay/view/components/text-form-field/custom_text_field.dart';
import 'package:viserpay/view/components/text/label_text.dart';
import 'package:viserpay/view/screens/auth/kyc/section/kyc_checkbox_section.dart';
import 'package:viserpay/view/screens/auth/kyc/section/kyc_date_time_section.dart';
import 'package:viserpay/view/screens/auth/kyc/section/kyc_radio_section.dart';
import 'package:viserpay/view/screens/auth/kyc/section/kyc_select_section.dart';
import 'package:viserpay/view/screens/auth/kyc/section/kyc_text_section.dart';
import 'package:viserpay/view/screens/auth/kyc/widget/widget/choose_file_list_item.dart';
import 'package:zoom_tap_animation/zoom_tap_animation.dart';

class AddNewNomineeScreen extends StatefulWidget {
  const AddNewNomineeScreen({super.key});

  @override
  State<AddNewNomineeScreen> createState() => _AddNewNomineeScreenState();
}

class _AddNewNomineeScreenState extends State<AddNewNomineeScreen> {
  final formKey = GlobalKey<FormState>();

  @override
  void initState() {
    Get.put(ApiClient(sharedPreferences: Get.find()));
    Get.put(NomineeRepo(apiClient: Get.find()));
    final controller = Get.put(NomineeController(nomineeRepo: Get.find()));
    super.initState();
    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      controller.initialize();
    });
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: MyColor.colorWhite,
      appBar: CustomAppBar(
        title: MyStrings.nominee,
        isTitleCenter: true,
        elevation: 0.1,
        action: [
          //   HistoryWidget(routeName: RouteHelper.sendMoneyHistoryScreen),
          const SizedBox(width: Dimensions.space20),
        ],
      ),
      body: GetBuilder<NomineeController>(
        builder: (controller) {
          return Skeletonizer(
            enabled: controller.isLoading,
            child: SingleChildScrollView(
              padding: Dimensions.defaultPaddingHV,
              child: Form(
                key: formKey,
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    CustomTextField(
                      isRequired: true,
                      hintText: '',
                      needOutlineBorder: true,
                      labelText: MyStrings.name,
                      textInputType: TextInputType.text,
                      controller: controller.nameController,
                      validator: (value) {
                        if (value.toString().isEmpty) {
                          return '${MyStrings.name} ${MyStrings.isRequired}';
                        } else {
                          return null;
                        }
                      },
                      onChanged: (value) {},
                      maxLines: 1,
                    ),
                    const SizedBox(height: Dimensions.space15),
                    LabelText(
                      text: "Nominee Image",
                      isRequired: true,
                    ),
                    const SizedBox(height: Dimensions.space10),
                    ZoomTapAnimation(
                      onTap: () {
                        controller.pickFile(0, isImageFile: true);
                      },
                      child: Container(
                        padding: const EdgeInsets.all(Dimensions.space10),
                        width: 200,
                        height: 150,
                        decoration: BoxDecoration(
                          border: Border.all(color: MyColor.primaryColor, width: .5),
                          borderRadius: BorderRadius.circular(Dimensions.mediumRadius),
                          color: MyColor.primaryColor.withValues(alpha: 0.1),
                        ),
                        child: Stack(
                          clipBehavior: Clip.none,
                          children: [
                            if (controller.imageFile != null) ...[
                              Image.file(
                                controller.imageFile!,
                                width: double.infinity,
                                height: 150,
                                fit: BoxFit.cover,
                              ),
                              Positioned(
                                top: -20,
                                right: -20,
                                child: Container(
                                  padding: const EdgeInsets.all(Dimensions.space5),
                                  decoration: BoxDecoration(
                                    color: MyColor.colorRed,
                                    shape: BoxShape.circle,
                                  ),
                                  child: const Icon(Icons.upload, color: MyColor.colorWhite),
                                ),
                              ),
                            ] else ...[
                              Positioned.fill(
                                child: Align(
                                  alignment: Alignment.center,
                                  child: Container(
                                    padding: const EdgeInsets.all(Dimensions.space5),
                                    decoration: BoxDecoration(
                                      color: MyColor.colorRed,
                                      shape: BoxShape.circle,
                                    ),
                                    child: const Icon(Icons.upload, color: MyColor.colorWhite),
                                  ),
                                ),
                              ),
                            ],
                          ],
                        ),
                      ),
                    ),
                    const SizedBox(height: Dimensions.space15),
                    CustomTextField(
                      isRequired: true,
                      hintText: '',
                      needOutlineBorder: true,
                      labelText: "Birth Date",
                      textInputType: TextInputType.text,
                      controller: controller.birthDateController,
                      onChanged: (value) {},
                      maxLines: 1,
                      readOnly: true,
                      onTap: () {
                        controller.changeSelectedDateOnlyValue(0, context, isBirthDate: true);
                      },
                    ),
                    const SizedBox(height: Dimensions.space15),
                    ListView.builder(
                      itemCount: controller.nomineeFormList.length,
                      shrinkWrap: true,
                      physics: const NeverScrollableScrollPhysics(),
                      itemBuilder: (ctx, index) {
                        FormModel? model = controller.nomineeFormList[index];
                        return Column(
                          children: [
                            if (MyUtils.getTextInputType(model.type ?? 'text')) ...[
                              KycTextAnEmailSection(
                                onChanged: (value) {
                                  controller.changeSelectedValue(value, index);
                                },
                                model: model,
                              )
                            ] else if (model.type == "select") ...[
                              KycSelectSection(
                                onChanged: (value) {
                                  controller.changeSelectedValue(value, index);
                                },
                                model: model,
                              )
                            ] else if (model.type == 'radio') ...[
                              KycRadioSection(
                                model: model,
                                onChanged: (selectedIndex) {
                                  controller.changeSelectedRadioBtnValue(index, selectedIndex);
                                },
                                selectedIndex: controller.nomineeFormList[index].options?.indexOf(model.selectedValue ?? '') ?? 0,
                              )
                            ] else if (model.type == "checkbox") ...[
                              KycCheckBoxSection(
                                model: model,
                                onChanged: (value) {
                                  controller.changeSelectedCheckBoxValue(index, value);
                                },
                                selectedValue: controller.nomineeFormList[index].cbSelected,
                              )
                            ] else if (model.type == "datetime" || model.type == "date" || model.type == "time") ...[
                              KycDateTimeSection(
                                model: model,
                                onChanged: (value) {
                                  controller.changeSelectedValue(value, index);
                                },
                                onTap: () {
                                  printX(model.type);
                                  if (model.type == "time") {
                                    controller.changeSelectedTimeOnlyValue(index, context);
                                  } else if (model.type == "date") {
                                    controller.changeSelectedDateOnlyValue(index, context);
                                  } else {
                                    controller.changeSelectedDateTimeValue(index, context);
                                  }
                                },
                                controller: controller.nomineeFormList[index].textEditingController!,
                              )
                            ],
                            model.type == 'file'
                                ? Column(
                                    crossAxisAlignment: CrossAxisAlignment.start,
                                    children: [
                                      FormRow(label: (model.name ?? '').tr, isRequired: model.isRequired == 'optional' ? false : true),
                                      Padding(
                                        padding: const EdgeInsets.symmetric(vertical: Dimensions.textToTextSpace),
                                        child: InkWell(
                                          borderRadius: BorderRadius.circular(Dimensions.mediumRadius),
                                          onTap: () {
                                            controller.pickFile(index);
                                          },
                                          child: ChooseFileItem(fileName: model.selectedValue ?? MyStrings.chooseFile),
                                        ),
                                      ),
                                    ],
                                  )
                                : const SizedBox(),
                            const SizedBox(height: Dimensions.space10),
                          ],
                        );
                      },
                    ),
                    const SizedBox(height: Dimensions.space25),
                    Center(
                      child: GradientRoundedButton(
                        isLoading: controller.isSubmitLoading,
                        press: () {
                          if (formKey.currentState!.validate()) {
                            controller.addNewNominee();
                          }
                        },
                        text: MyStrings.submit.tr,
                      ),
                    ),
                  ],
                ),
              ),
            ),
          );
        },
      ),
    );
  }
}
